# HP_flow

The following folder contains the case files and post-processing scripts to validate the cyclic heat transfer solver against Hagen–Poiseuille flow.

### GCI

Contains the case files for the Grid Convergence Index (GCI).

### Re_runs_steady

Contains the files for the steady state solver case with air and water. Only a Reynolds number of 50 is provided, but the run_all script can generate the rest of the cases used in this study when uncommented.

### Re_runs_unsteady

Contains the files for the unsteady state solver case with air and water. Only a Reynolds number of 50 is provided, but the run_all script can generate the rest of the cases used in this study when uncommented.

## analytical_solution_comparison.ipynb

This ipython notebook compares the cases against the analytical solution. Cases and fluid are specified within the script. This should be run on the data sets provided, or after running the cases and post-processing with ParaView.

## analytical_solution_comparison.py

This is the same as the ipython notebook above but in python.

## convergence_check.ipyn

This ipython notebook is used to check that the velocity and lambda have converged for each case.

## GCI_comparison.ipynb

This ipython notebook performs the Grid Convergence Index (GCI) calculations and plots the solutions.

## output_slice_data.py

This python file is a ParaView python file used to automatically post-process each case using ParaViews built in pvbatch command.

## stanton_number.ipynb

This ipython notebook plots all the cases in terms of stanton number in order to detemine if viscosity plays a role in the heat transfer between the two fluids.

## TemperatureField.py

This python class file contains the calculations for the analytical solution for Hagen–Poiseuille flow. This is used by the comparison script to calculate the analytical heat transfer solution for each case.
