# trace generated using paraview version 5.11.0-RC1
#import paraview
#paraview.compatibility.major = 5
#paraview.compatibility.minor = 11

#### import the simple module from the paraview
from paraview.simple import *
from pathlib import Path

#### disable automatic camera reset on 'Show'
paraview.simple._DisableFirstRenderCameraReset()

folder_path = Path(r'./')

files = list(folder_path.glob('**/*.foam'))

for file in files:
    # create a new 'OpenFOAMReader'
    re40foam = OpenFOAMReader(registrationName='Re40.foam', FileName=str(file))
    re40foam.MeshRegions = ['internalMesh']
    re40foam.CellArrays = ['T', 'U', 'p', 'thetaBar', 'UMean', 'TMean', 'pMean']

    # get animation scene
    animationScene1 = GetAnimationScene()

    # update animation scene based on data timesteps
    animationScene1.UpdateAnimationUsingDataTimeSteps()

    # get active view
    renderView1 = GetActiveViewOrCreate('RenderView')

    # show data in view
    re40foamDisplay = Show(re40foam, renderView1, 'UnstructuredGridRepresentation')

    # get color transfer function/color map for 'p'
    pLUT = GetColorTransferFunction('p')

    # get opacity transfer function/opacity map for 'p'
    pPWF = GetOpacityTransferFunction('p')

    # trace defaults for the display properties.
    re40foamDisplay.Representation = 'Surface'
    re40foamDisplay.ColorArrayName = ['POINTS', 'p']
    re40foamDisplay.LookupTable = pLUT
    re40foamDisplay.SelectTCoordArray = 'None'
    re40foamDisplay.SelectNormalArray = 'None'
    re40foamDisplay.SelectTangentArray = 'None'
    re40foamDisplay.OSPRayScaleArray = 'p'
    re40foamDisplay.OSPRayScaleFunction = 'PiecewiseFunction'
    re40foamDisplay.SelectOrientationVectors = 'U'
    re40foamDisplay.ScaleFactor = 0.1
    re40foamDisplay.SelectScaleArray = 'p'
    re40foamDisplay.GlyphType = 'Arrow'
    re40foamDisplay.GlyphTableIndexArray = 'p'
    re40foamDisplay.GaussianRadius = 0.005
    re40foamDisplay.SetScaleArray = ['POINTS', 'p']
    re40foamDisplay.ScaleTransferFunction = 'PiecewiseFunction'
    re40foamDisplay.OpacityArray = ['POINTS', 'p']
    re40foamDisplay.OpacityTransferFunction = 'PiecewiseFunction'
    re40foamDisplay.DataAxesGrid = 'GridAxesRepresentation'
    re40foamDisplay.PolarAxes = 'PolarAxesRepresentation'
    re40foamDisplay.ScalarOpacityFunction = pPWF
    re40foamDisplay.ScalarOpacityUnitDistance = 0.08351940696482736
    re40foamDisplay.OpacityArrayName = ['POINTS', 'p']
    re40foamDisplay.SelectInputVectors = ['POINTS', 'U']
    re40foamDisplay.WriteLog = ''

    # init the 'PiecewiseFunction' selected for 'ScaleTransferFunction'
    re40foamDisplay.ScaleTransferFunction.Points = [-5.708102594435125e-22, 0.0, 0.5, 0.0, -2.488640071193134e-22, 1.0, 0.5, 0.0]

    # init the 'PiecewiseFunction' selected for 'OpacityTransferFunction'
    re40foamDisplay.OpacityTransferFunction.Points = [-5.708102594435125e-22, 0.0, 0.5, 0.0, -2.488640071193134e-22, 1.0, 0.5, 0.0]

    # reset view to fit data
    renderView1.ResetCamera(False)

    # get the material library
    materialLibrary1 = GetMaterialLibrary()

    # show color bar/color legend
    re40foamDisplay.SetScalarBarVisibility(renderView1, True)

    # update the view to ensure updated data information
    renderView1.Update()

    # get 2D transfer function for 'p'
    pTF2D = GetTransferFunction2D('p')

    # create a new 'Slice'
    slice1 = Slice(registrationName='Slice1', Input=re40foam)
    slice1.SliceType = 'Plane'
    slice1.HyperTreeGridSlicer = 'Plane'
    slice1.SliceOffsetValues = [0.0]

    # init the 'Plane' selected for 'SliceType'
    slice1.SliceType.Origin = [0.5, 0.0, 0.009999999776482582]

    # init the 'Plane' selected for 'HyperTreeGridSlicer'
    slice1.HyperTreeGridSlicer.Origin = [0.5, 0.0, 0.009999999776482582]

    # Properties modified on slice1.SliceType
    slice1.SliceType.Normal = [0.0, 0.0, 1.0]

    # show data in view
    slice1Display = Show(slice1, renderView1, 'GeometryRepresentation')

    # trace defaults for the display properties.
    slice1Display.Representation = 'Surface'
    slice1Display.ColorArrayName = ['POINTS', 'p']
    slice1Display.LookupTable = pLUT
    slice1Display.SelectTCoordArray = 'None'
    slice1Display.SelectNormalArray = 'None'
    slice1Display.SelectTangentArray = 'None'
    slice1Display.OSPRayScaleArray = 'p'
    slice1Display.OSPRayScaleFunction = 'PiecewiseFunction'
    slice1Display.SelectOrientationVectors = 'U'
    slice1Display.ScaleFactor = 0.1
    slice1Display.SelectScaleArray = 'p'
    slice1Display.GlyphType = 'Arrow'
    slice1Display.GlyphTableIndexArray = 'p'
    slice1Display.GaussianRadius = 0.005
    slice1Display.SetScaleArray = ['POINTS', 'p']
    slice1Display.ScaleTransferFunction = 'PiecewiseFunction'
    slice1Display.OpacityArray = ['POINTS', 'p']
    slice1Display.OpacityTransferFunction = 'PiecewiseFunction'
    slice1Display.DataAxesGrid = 'GridAxesRepresentation'
    slice1Display.PolarAxes = 'PolarAxesRepresentation'
    slice1Display.SelectInputVectors = ['POINTS', 'U']
    slice1Display.WriteLog = ''

    # init the 'PiecewiseFunction' selected for 'ScaleTransferFunction'
    slice1Display.ScaleTransferFunction.Points = [-5.708102594435125e-22, 0.0, 0.5, 0.0, -2.488640071193134e-22, 1.0, 0.5, 0.0]

    # init the 'PiecewiseFunction' selected for 'OpacityTransferFunction'
    slice1Display.OpacityTransferFunction.Points = [-5.708102594435125e-22, 0.0, 0.5, 0.0, -2.488640071193134e-22, 1.0, 0.5, 0.0]

    # hide data in view
    Hide(re40foam, renderView1)

    # show color bar/color legend
    slice1Display.SetScalarBarVisibility(renderView1, True)

    # update the view to ensure updated data information
    renderView1.Update()

    # toggle interactive widget visibility (only when running from the GUI)
    HideInteractiveWidgets(proxy=slice1.SliceType)

    # get layout
    layout1 = GetLayout()

    # split cell
    layout1.SplitHorizontal(0, 0.5)

    # set active view
    SetActiveView(None)

    # Create a new 'SpreadSheet View'
    spreadSheetView1 = CreateView('SpreadSheetView')
    spreadSheetView1.ColumnToSort = ''
    spreadSheetView1.BlockSize = 1024

    # show data in view
    slice1Display_1 = Show(slice1, spreadSheetView1, 'SpreadSheetRepresentation')

    # assign view to a particular cell in the layout
    AssignViewToLayout(view=spreadSheetView1, layout=layout1, hint=2)

    # Properties modified on spreadSheetView1
    spreadSheetView1.ColumnToSort = 'Points_0'
    spreadSheetView1.InvertOrder = 1

    # Properties modified on spreadSheetView1
    spreadSheetView1.InvertOrder = 0

    # export view
    ExportView(str(file.parent.parent.joinpath(file.stem + '.csv')), view=spreadSheetView1)

    #================================================================
    # addendum: following script captures some of the application
    # state to faithfully reproduce the visualization during playback
    #================================================================

    #--------------------------------
    # saving layout sizes for layouts

    # layout/tab size in pixels
    layout1.SetSize(924, 656)

    #-----------------------------------
    # saving camera placements for views

    # current camera placement for renderView1
    renderView1.CameraPosition = [0.5, 0.0, 2.1702213610534677]
    renderView1.CameraFocalPoint = [0.5, 0.0, 0.009999999776482582]
    renderView1.CameraParallelScale = 0.5591064299357767

    #--------------------------------------------
    # uncomment the following to render all views
    # RenderAllViews()
    # alternatively, if you want to write images, you can use SaveScreenshot(...).
    Disconnect()
    Connect()