# Case-files #

## Description ##

Cases can be run after the solvers are compiled. Here an Allrun script is provided in each folder that copies the lowest Reynolds number case and changes the initial conditions. Initially, only the Re50 case is run for a quick test of the solver, but more cases can be run by uncommenting in the corresponding Allrun script.

There is an overall **run_all** script in the top most folder that will run all the cases in the subfolders.

### case-files/corrugated_flow ###

These case files have the cases for the **arc** and **sine** wavy geometry.

Each folder has the case files for the **steady (SIMPLE)** and **unsteady (PIMPLE)** solvers at different Reynolds numbers.

The **run_all** script will run the first cases for the arc and sine geometry, for both the steady and unsteady solvers, using air and water as the fluid.

In addition, each folder contains a **GCI** file that runs the Grid Independence Index (GCI) study.

### case-files/HP_flow ###

These case files are for Hagen-Poiseuille Flow

Each folder has the case files for the **steady (SIMPLE)** and **unsteady (PIMPLE)** solvers at different Reynolds numbers.

The **run_steady_unsteady** script will run the first cases, for both the steady and unsteady solvers, using air and water as the fluid.

In addition, the folder contains a **GCI** file that runs the Grid Independence Index (GCI) study.

### **----------------------------Python Scripts--------------------------------** ###

### case-files/corrugated_flow

**arc_sine_combined_comparison.ipynb** is an ipython notebook that generates the data for the both the arc and sine case. This should be run on the data sets provided, or after running the cases and post-processing with ParaView.

**convergence_check.ipynb** is an ipython notebook is used to ensure that the velocity and \lambda fields have converged to a constant value.

**corrugated_solution_comparison.ipynb** is an ipython notebook post-processes the data for both the sine and arc case. Cases and fluids are specified in the script and all the plots provided are generated.

**corrugated_solution_comparison.py** is the same as the ipython notebook, but in python.

**GCI_comparison_corrugated.ipynb** is an ipython notebook performs the Grid Convergence Index (GCI) calculations and plots the solutions.

**output_slice_data.py** is a python file is a ParaView python file used to automatically post-process each case using ParaViews built in pvbatch command.

**wavy_channel_data.xlsx** is an excel file contains all the published data for the arc and sine channel cases.

### case-files/HP_flow

**analytical_solution_comparison.ipynb** is an ipython notebook compares the cases against the analytical solution. Cases and fluid are specified within the script. This should be run on the data sets provided, or after running the cases and post-processing with ParaView.

**analytical_solution_comparison.py** is the same as the ipython notebook above but in python.

**convergence_check.ipyn** is an ipython notebook is used to check that the velocity and lambda have converged for each case.

**GCI_comparison.ipynb** is an ipython notebook performs the Grid Convergence Index (GCI) calculations and plots the solutions.

**output_slice_data.py** is a python file is a ParaView python file used to automatically post-process each case using ParaViews built in pvbatch command.

**stanton_number.ipynb** is an ipython notebook plots all the cases in terms of stanton number in order to detemine if viscosity plays a role in the heat transfer between the two fluids.

**TemperatureField.py** is the python class file contains the calculations for the analytical solution for Hagen–Poiseuille flow. This is used by the comparison script to calculate the analytical heat transfer solution for each case.

### License ###
This work is licensed under CC BY 4.0. To view a copy of this license, visit http://creativecommons.org/licenses/by/4.0/