# corrugated_flow

The following folder contains the case files and post-processing scripts to validate the cyclic heat transfer solver against a wavy channel geometry.

## arc

Contains the files for the arc channel case.

### GCI

Contains the case files for the Grid Convergence Index (GCI).

### Re_runs_steady

Contains the files for the steady state solver case with air and water. Only a Reynolds number of 50 is provided, but the run_all script can generate the rest of the cases used in this study when uncommented.

### Re_runs_unsteady

Contains the files for the unsteady state solver case with air and water. Only a Reynolds number of 50 is provided, but the run_all script can generate the rest of the cases used in this study when uncommented.

## sine

Contains the files for the sine channel case.

### Re_runs_steady

Contains the files for the steady state solver case with air and water. Only a Reynolds number of 50 is provided, but the run_all script can generate the rest of the cases used in this study when uncommented.

### Re_runs_unsteady

Contains the files for the unsteady state solver case with air and water. Only a Reynolds number of 50 is provided, but the run_all script can generate the rest of the cases used in this study when uncommented.

## arc_sine_combined_comparison.ipynb

This ipython notebook that generates the data for the both the arc and sine case. This should be run on the data sets provided, or after running the cases and post-processing with ParaView.

## convergence_check.ipynb

This ipython notebook is used to ensure that the velocity and \lambda fields have converged to a constant value.

## corrugated_solution_comparison.ipynb

This ipython notebook post-processes the data for both the sine and arc case. Cases and fluids are specified in the script and all the plots provided are generated.

## corrugated_solution_comparison.py

Same as the ipython notebook, but in python.

## GCI_comparison_corrugated.ipynb

This ipython notebook performs the Grid Convergence Index (GCI) calculations and plots the solutions.

## output_slice_data.py

This python file is a ParaView python file used to automatically post-process each case using ParaViews built in pvbatch command.

## wavy_channel_data.xlsx

This excel file contains all the published data for the arc and sine channel cases.
