# solver-files #

## Description ##

This folder contains the files needed to compile for the cyclic heat transfer solver.

There is an overall **Allwclean** script that will clean all the cases.

There is an overall **Allwmake** script which will make both the **steady (SIMPLE)** and **unsteady (PIMPLE)** solver.

The only difference in the files is a slight variation in how the iterations are handled and so only the simpleFoam files will be described.

### heatTransfer/CyclicSimpleFoam ###

**compile_code.sh** contains a bash script to compile the code as a OpenFOAM library.

**createFields.H** creates all the field variables.

**cyclicHeatSimpleFoam.C** is the solver loop modified from the original simpleFOAM solver.

**lambdaEqn.H** solves for the decay rate constant $$\lambda_L$$.

**pEqn.H** solves the pressure equation.

**readTransportProperties** reads the variables from the case/constant/transportProperties file.

**TEqn.H** calculates the temperature, but is not needed at this time.

**thetaBarEqn.H** calculates thetaBar from from the calculated $$\lambda_L$$.

**thetaEqn.H** calculates the temperature from $$\theta$$.

**UEqn.H** calculates the velocity field.

### License ###
This work is licensed under CC BY 4.0. To view a copy of this license, visit http://creativecommons.org/licenses/by/4.0/