clear
clc
close all

line=2;
words=16;
set(0,'DefaultLineLinewidth',line);
set(0,'DefaultAxesFontsize',words);
set(0,'DefaultLineMarkersize',1);

nn = [1,4,6];
% File names
name_of = "lineX" + string(nn) + "_STilde_epsilon_k_nut_phit_U.xy";

% Parameters
nu = 1.56e-05;
Cmu = 0.22;
Ct = 4;
HH = 1.27e-2;

Tlim_fun = @(kk, epsilon) sqrt((kk./epsilon).^2 + Ct^2*nu./epsilon);
realBound_fun = @(phit, Stilde) 1./(sqrt(3.0)*Cmu*phit.*Stilde);

nut_fun = @(phit, kk, Tlim, realBound,Stilde) Cmu*phit.*kk.*min(Tlim,realBound);


for ii = 1:3
    % OF
    clear lagEB_of
    lagEB_of = readmatrix(name_of(ii),"FileType","text");
    yy_of = lagEB_of(:,1);
    Stilde_of = lagEB_of(:,2);
    epsilon_of = lagEB_of(:,3);
    kk_of = lagEB_of(:,4);
    nut_of = lagEB_of(:,5)/nu;
    phit_of = lagEB_of(:,6);
    
    

    Tlim_of = Tlim_fun(kk_of,epsilon_of);
    Tlim_of = max(Tlim_of, 1e-6);

    realBound_of = realBound_fun(phit_of,Stilde_of);
    nut_comp_of = nut_fun(phit_of,kk_of,Tlim_of,realBound_of, Stilde_of)/nu;

    figure(ii)
    hold on
    grid on
    box on
    plot(nut_of,yy_of/HH,'-')
    plot(nut_comp_of,yy_of/HH,'-.')
    xlabel('\nu_t/\nu')
    ylabel('y/H')
    legend('Extracted','Computed','location','best')
    saveas(figure(ii),"x"+string(nn(ii))+".svg")


end




