import matplotlib.pyplot as plt
import math
import numpy as np


# Parameters
nu = 1.56e-05
Cmu = 0.22
HH = 0.0127
Ct = 4.0

def Tlim_fun(kk,epsilon):
    Tlim = np.sqrt(np.square(np.divide(kk,epsilon)) + Ct**2*nu/epsilon)
    return Tlim

def realBound_fun(phit,Stilde):
    realBound = 1.0/(Cmu*math.sqrt(3.0)*np.multiply(phit,Stilde))
    return realBound
            
def nut_plot(realBound,Tlim,phit,kk,yy,nut):
    nut_comp = Cmu*np.multiply(np.multiply(phit,kk),np.minimum(Tlim,realBound))/nu
    plt.plot(nut, yy/HH, label = "OF")
    plt.plot(nut_comp, yy/HH,"--", label = "OF-computed")
    plt.xlabel(r'$\nu_t/\nu$')
    plt.ylabel(r'$y/H$')
    plt.legend({'Extracted', 'Computed'})
    plt.grid(True)
    plt.savefig("x"+str(ii)+".svg", format = 'svg')
    plt.show()
    

nn = [1, 4, 6]
# File names
for ii in nn:
    name_of = "lineX" + str(ii) + "_STilde_epsilon_k_nut_phit_U.xy"
    lagEB_of = np.loadtxt(name_of)
    yy_of = lagEB_of[:,0]
    Stilde_of = lagEB_of[:,1];
    epsilon_of = lagEB_of[:,2];
    kk_of = lagEB_of[:,3];
    nut_of = lagEB_of[:,4]/nu;
    phit_of = lagEB_of[:,5]   
    
    Tlim_of = Tlim_fun(kk_of,epsilon_of)         
    realBound_of = realBound_fun(phit_of,Stilde_of)
    nut_plot(realBound_of,Tlim_of,phit_of,kk_of,yy_of,nut_of)
            



