#!/usr/bin/env python3
# -*- coding: utf-8 -*-
"""
Created on Tue Dec 10 14:33:26 2024

@author: ygaillard
"""
import os

import pyvista as pv

import numpy as np

import matplotlib.pyplot as plt

import pandas as pd

def sph2cart(r, theta, phi):
    x=r*np.sin(theta)*np.cos(phi)
    y=r*np.sin(theta)*np.sin(phi)
    z=r*np.cos(theta)
    return (x,y,z)


def cart2sphMath(x,y,z):
    XsqPlusYsq = x**2 + y**2
    r = np.sqrt(XsqPlusYsq + z**2)               # r                         # phi
    elev=np.arccos(z/r)
    az=np.arctan2(y,x)
    return(r, elev, az)

def cart2sphVec(varAll,x,y,z):
    [r,theta,phi]=cart2sphMath(x,y,z)
    
    if np.ndim(varAll)>2:        
        U_r=     np.sin(theta)*np.cos(phi)*varAll[:,:,0]+np.sin(theta)*np.sin(phi)*varAll[:,:,1]+np.cos(theta)*varAll[:,:,2]
        U_theta= np.cos(theta)*np.cos(phi)*varAll[:,:,0]+np.cos(theta)*np.sin(phi)*varAll[:,:,1]-np.sin(theta)*varAll[:,:,2]
        u_az=  -np.sin(phi)*              varAll[:,:,0]+np.cos(phi)*              varAll[:,:,1]            
        return [U_r,U_theta,u_az]
    else:
        U_r=     np.sin(theta)*np.cos(phi)*varAll[:,0]+np.sin(theta)*np.sin(phi)*varAll[:,1]+np.cos(theta)*varAll[:,2]
        U_theta= np.cos(theta)*np.cos(phi)*varAll[:,0]+np.cos(theta)*np.sin(phi)*varAll[:,1]-np.sin(theta)*varAll[:,2]
        u_az=  -np.sin(phi)*              varAll[:,0]+np.cos(phi)*              varAll[:,1]            
        return [U_r,U_theta,u_az]
    
    

r1=0.7/(1-0.7)
r2=1/(1-0.7)

EquatorCSV = pd.read_csv('Equator.csv')
PoleCSV = pd.read_csv('Pole.csv')

if not os.path.exists("mesh.foam"):
    os.close(os.open("mesh.foam", os.O_CREAT))

reader = pv.POpenFOAMReader('mesh.foam')
reader.case_type = 'decomposed'
reader.set_active_time_value(reader.time_values[-1])

mesh = reader.read()       

internal_mesh=mesh['internalMesh']

[r,__,__]=cart2sphMath(internal_mesh.points[:,0], internal_mesh.points[:,1], internal_mesh.points[:,2])

[__,__,u_az]=cart2sphVec(internal_mesh.point_data['U'], internal_mesh.points[:,0], internal_mesh.points[:,1], internal_mesh.points[:,2])

internal_mesh.point_data['r']=r

internal_mesh.point_data['u_az']=u_az
        

EquatorPlot=internal_mesh.sample_over_line(sph2cart(r1,np.pi/2,0),sph2cart(r2,np.pi/2,0),resolution=1000)
PolarPlot=internal_mesh.sample_over_line(sph2cart(r1,0,0),sph2cart(r2,0,0),resolution=1000)

for var in ['T','u_az']:
    plt.plot(EquatorPlot['r'],EquatorPlot[var])
    plt.plot(EquatorCSV['r'],EquatorCSV[var],'r+')
    plt.title(var+" on the Equator")
    plt.xlabel("r")
    plt.ylabel(var)
    plt.show()


plt.plot(PolarPlot['r'],PolarPlot['T'])
plt.plot(PoleCSV['r'],PoleCSV['T'],'r+')
plt.title("T on the Pole")
plt.xlabel("r")
plt.ylabel('T')

    
    
    
