
This project includes two mesh configurations for simulations, and their selection and usage are controlled via the provided **Allrun** scripts. Detailed instructions are outlined below.

## Mesh Modes

The simulation supports two modes of mesh:

1.  **Coarse Mesh**: Optimized for quick execution, suitable for testing and lower-resolution results. This mode runs efficiently on 2 cores.
    
2.  **Fine Mesh**: High-resolution configuration with 41 million cells. This mesh is used to process results presented in this study and requires substantial computational resources.
    

When executing the `Allrun` script, you will be prompted to specify the mesh type:

-   Enter **"fine"** for the high-resolution mesh.
    
-   Enter **"coarse"** for the low-resolution mesh.
    

The appropriate resources will be prepared automatically based on your selection.

## Postprocessing

Postprocessing can be performed using one of the following methods:

### Method 1: ParaView

1.  Use the provided ParaView state file `linePlots.pvsm`.
    
2.  Load the corresponding case mesh.
    
3.  Ensure **pvpython** is available with your ParaView version for full compatibility.
    

### Method 2: Pure Python

1.  Execute the `postProcess.py` file located in each case folder, i.e. `python postProcess.py`.
    
2.  Required Python packages:
    
    -   `os`
        
    -   `pyvista`
        
    -   `numpy`
        
    -   `matplotlib`
        
    -   `pandas`
    
3.  The script will generate plots for:
    
    -   Temperature (`T`) on the equator and the pole for the current result  (blue solid line) and fine mesh result (red cross).
        
    -   Azimuthal velocity (`u_az`) on the equator (blue solid line) fine mesh result (red cross).
        

## Notes on Results

-   The **fine mesh** provides results consistent with the current work data.
    
-   The **coarse mesh** is not as accurate, and slight deviations from the current work data should be expected, especially in terms of a shift in plotted values.
    

