# README #

This README documents the compilation of the IHCP solver and
running the case example.

### Steps to compile the IHCP solver ###

* OpenFOAM installed (tested with OF-7)
* Install NLopt library (https://nlopt.readthedocs.io/en/latest/NLopt_Installation/)
* tested with NLopt version 2.6.2

`git clone git://github.com/stevengj/nlopt`
`cd nlopt`
`mkdir build`
`cd build`
`cmake ..`
`make`
`sudo make install`

* run the script ./Allwmake

### Running the case example ###

* go to the case folder
* ./Allrun
* results are continuously saved into results.csv file.

### Note1: ###

* The mesh and geometry were generated from the ANSYS FLUENT cas file
(sensorLinear.cas)
* `fluentMeshToFoam -2D 0.001 sensorLinear.cas -writeZones`
* `surfaceToPatch front.stl` (split frontAndBackPatches into front and back)
* `extrudeMesh` (extrudeMeshDict) to convert into axisymmetric wedge mesh

### Note2: ###
* number of forward time steps (stabLoops) and
temperature sensor locations (sensors) in transportProperties 
* The temperature data from the experiment in Texp file.

