// reads temperature from thermocouple measurement
IOdictionary Texp
(
    IOobject
    (
        "Texp",
        runTime.constant(),
        mesh,
        IOobject::MUST_READ,
        IOobject::NO_WRITE
    )
);

scalarField TempProbe(Texp.lookup("Texp"));

//  Read transportProperties
IOdictionary transportProperties
(
    IOobject
    (
        "transportProperties",
        runTime.constant(),
        mesh,
        IOobject::MUST_READ,
        IOobject::NO_WRITE
    )
);


//  Read number of forward steps for IHCP
const int stabLoops(readInt(transportProperties.lookup("stabLoops")));
Info<< "Number of stability loops is " << stabLoops << endl;

//  Read position of each thermocouple
Foam::List<vector> sensors(transportProperties.lookup("sensors"));

Info<< "Reading stabLoops and sensor position\n" << endl;

// and determine corresponding cells in which thermocouples resides
Foam::List<label> sensorsCellI(0); 
forAll(sensors,sensorI)
{
    label sensorCellI = mesh.findCell(sensors[sensorI]);
    sensorsCellI.append(sensorCellI);
}

// and read interpolation scheme
dictionary interpolationDict = mesh.solutionDict().subDict("interpolationSchemes" );


//  Assamble k-T data
IOdictionary kTData
(
    IOobject
    (
        "kTData",
        runTime.constant(),
        mesh,
        IOobject::MUST_READ,
        IOobject::NO_WRITE
    )
);


scalarField Ag_k_T(kTData.lookup("Ag_k_T"));
scalarField Ag_k(kTData.lookup("Ag_k"));
//~ Info<< "Ag_k_T :" << Ag_k_T << endl;



scalarField Inconel_k_T(kTData.lookup("Inconel_k_T"));
scalarField Inconel_k(kTData.lookup("Inconel_k"));



scalarField MgO_k_T(kTData.lookup("MgO_k_T"));
scalarField MgO_k(kTData.lookup("MgO_k"));



scalarField NiCr_k_T(kTData.lookup("NiCr_k_T"));
scalarField NiCr_k(kTData.lookup("NiCr_k"));



scalarField steel_k_T(kTData.lookup("steel_k_T"));
scalarField steel_k(kTData.lookup("steel_k"));


//  Array of T data sets
Foam::List<scalarField *>  TDataList(0);


//  Array of k data sets
Foam::List<const scalarField *>  kDataList(0);


//  Add data
TDataList.append(&Ag_k_T);
kDataList.append(&Ag_k);


TDataList.append(&Inconel_k_T);
kDataList.append(&Inconel_k);


TDataList.append(&MgO_k_T);
kDataList.append(&MgO_k);


TDataList.append(&NiCr_k_T);
kDataList.append(&NiCr_k);


TDataList.append(&steel_k_T);
kDataList.append(&steel_k);


//  Fix grad C to K
forAll(TDataList, TId)
{
    *(TDataList[TId]) -= scalar(273.15);
}

//~ Info<< "TDataList[0] : " << *(TDataList[0]) << endl;
//~ Info<< "kDataList[0] : " << *(kDataList[0]) << endl;


//  Test interpolator
//~ Info<< "Testing interpolator" << nl << nl
    //~ << interpolateXY(T.internalField().field(), *(TDataList[0]), *(kDataList[0]))
    //~ << nl << nl
    //~ << interpolateXY(T, *(TDataList[0]), *(kDataList[0]))    
    //~ << endl;

//  Assamble rho-T data
IOdictionary rhoTData
(
    IOobject
    (
        "rhoTData",
        runTime.constant(),
        mesh,
        IOobject::MUST_READ,
        IOobject::NO_WRITE
    )
);


scalarField Ag_rho_T(rhoTData.lookup("Ag_rho_T"));
scalarField Ag_rho(rhoTData.lookup("Ag_rho"));
//~ Info<< "Ag_rho_T :" << Ag_rho_T << endl;



scalarField Inconel_rho_T(rhoTData.lookup("Inconel_rho_T"));
scalarField Inconel_rho(rhoTData.lookup("Inconel_rho"));



scalarField MgO_rho_T(rhoTData.lookup("MgO_rho_T"));
scalarField MgO_rho(rhoTData.lookup("MgO_rho"));



scalarField NiCr_rho_T(rhoTData.lookup("NiCr_rho_T"));
scalarField NiCr_rho(rhoTData.lookup("NiCr_rho"));



scalarField steel_rho_T(rhoTData.lookup("steel_rho_T"));
scalarField steel_rho(rhoTData.lookup("steel_rho"));


//  Array of rhoT data sets
Foam::List<scalarField *>  rhoTDataList(0);


//  Array of rho data sets
Foam::List<const scalarField *>  rhoDataList(0);


//  Add data
rhoTDataList.append(&Ag_rho_T);
rhoDataList.append(&Ag_rho);


rhoTDataList.append(&Inconel_rho_T);
rhoDataList.append(&Inconel_rho);


rhoTDataList.append(&MgO_rho_T);
rhoDataList.append(&MgO_rho);


rhoTDataList.append(&NiCr_rho_T);
rhoDataList.append(&NiCr_rho);


rhoTDataList.append(&steel_rho_T);
rhoDataList.append(&steel_rho);


//  Fix grad C to K
forAll(rhoTDataList, TId)
{
    *(rhoTDataList[TId]) -= scalar(273.15);
}





//  Assamble cp-T data
IOdictionary cpTData
(
    IOobject
    (
        "cpTData",
        runTime.constant(),
        mesh,
        IOobject::MUST_READ,
        IOobject::NO_WRITE
    )
);


scalarField Ag_cp_T(cpTData.lookup("Ag_cp_T"));
scalarField Ag_cp(cpTData.lookup("Ag_cp"));
//~ Info<< "Ag_cp_T :" << Ag_cp_T << endl;



scalarField Inconel_cp_T(cpTData.lookup("Inconel_cp_T"));
scalarField Inconel_cp(cpTData.lookup("Inconel_cp"));



scalarField MgO_cp_T(cpTData.lookup("MgO_cp_T"));
scalarField MgO_cp(cpTData.lookup("MgO_cp"));



scalarField NiCr_cp_T(cpTData.lookup("NiCr_cp_T"));
scalarField NiCr_cp(cpTData.lookup("NiCr_cp"));



scalarField steel_cp_T(cpTData.lookup("steel_cp_T"));
scalarField steel_cp(cpTData.lookup("steel_cp"));


//  Array of cpT data sets
Foam::List<scalarField *>  cpTDataList(0);


//  Array of rho data sets
Foam::List<const scalarField *>  cpDataList(0);


//  Add data
cpTDataList.append(&Ag_cp_T);
cpDataList.append(&Ag_cp);


cpTDataList.append(&Inconel_cp_T);
cpDataList.append(&Inconel_cp);


cpTDataList.append(&MgO_cp_T);
cpDataList.append(&MgO_cp);


cpTDataList.append(&NiCr_cp_T);
cpDataList.append(&NiCr_cp);


cpTDataList.append(&steel_cp_T);
cpDataList.append(&steel_cp);


//  Fix grad C to K
forAll(cpTDataList, TId)
{
    *(cpTDataList[TId]) -= scalar(273.15);
}









