void calculateFlux
(
    scalar& F0,
    vector& F123,
    scalar& F4,
    const scalar& rhoOwn,
    const vector& UOwn,
    const scalar& pOwn,
    const scalar& rhoNei,
    const vector& UNei,
    const scalar& pNei,
    const vector& Sf,
    const scalar& magSf,
    const scalar& beta,
    const tensor& R,
    const tensor& RT
)
{
    if((rhoOwn <= 0) | (rhoNei <= 0))
    {
        Pout<< "rho error"<< endl;
    }

    roeFlux
    (
        F0,
        F123,
        F4,

        rhoOwn,
        R & UOwn,
        pOwn,

        rhoNei,
        R & UNei,
        pNei,

        beta
    );

    F0 *= magSf;
    F123 = RT & F123 * magSf;
    F4 *= magSf;
}
