// Rotate from n to x-axis

Info<< "Calculating internal face fluxes" << endl;

forAll(mesh.owner(), faceI)
{
    const label own = mesh.owner()[faceI];
    const label nei = mesh.neighbour()[faceI];

    const vector deltaOwn = mesh.Cf()[faceI] - mesh.C()[own];
    const vector deltaNei = mesh.Cf()[faceI] - mesh.C()[nei];

    calculateFlux
    (
        F0[faceI],
        F123[faceI],
        F4[faceI],

        rho[own]
      + (deltaOwn & gradRho[own]),

        U[own]
      + (deltaOwn & gradU[own]),

        p[own]
      + (deltaOwn & gradp[own]),

        rho[nei]
      + (deltaNei & gradRho[nei]),

        U[nei]
      + (deltaNei & gradU[nei]),

        p[nei]
      + (deltaNei & gradp[nei]),

        mesh.Sf()[faceI],
        mesh.magSf()[faceI],
        beta,

        R[faceI],
        RT[faceI]
    );
}

Info<< "Calculating boundary face fluxes" << endl;

forAll(mesh.boundary(), patchI)
{
    // Fluxes
    fvsPatchScalarField& pF0 = F0.boundaryFieldRef()[patchI];
    fvsPatchVectorField& pF123 = F123.boundaryFieldRef()[patchI];
    fvsPatchScalarField& pF4 = F4.boundaryFieldRef()[patchI];

    // Patch fields
    const fvPatchScalarField& pRho = rho.boundaryField()[patchI];
    const fvPatchVectorField& pU = U.boundaryField()[patchI];
    const fvPatchScalarField& pp = p.boundaryField()[patchI];

    // Gradients
    const fvPatchVectorField& pGradRho = gradRho.boundaryField()[patchI];
    const fvPatchTensorField& pGradU = gradU.boundaryField()[patchI];
    const fvPatchVectorField& pGradp = gradp.boundaryField()[patchI];

    // Face areas
    const vectorField& pSf = mesh.Sf().boundaryField()[patchI];
    const scalarField& pMagSf = mesh.magSf().boundaryField()[patchI];

    // Rotation matrices
    const fvsPatchTensorField& pR = R.boundaryField()[patchI];
    const fvsPatchTensorField& pRT = RT.boundaryField()[patchI];

    if(pp.coupled())
    {
        // Processor boundary

//        // Delta (option 1)
//        vectorField pDeltaOwn = pp.patch().fvPatch::delta();
//        vectorField pDeltaNei = pDeltaOwn - pp.patch().delta();

        // Delta (option 2)
        vectorField pDeltaOwn = pp.patch().Cf() - mesh.C().boundaryField()[patchI].patchInternalField();
        vectorField pDeltaNei = pp.patch().Cf() - mesh.C().boundaryField()[patchI].patchNeighbourField();

        forAll(pp, faceI)
        {
            vector Sf = pSf[faceI];
            scalar magSf = pMagSf[faceI];
            vector deltaOwn = pDeltaOwn[faceI];
            vector deltaNei = pDeltaNei[faceI];

            scalar rhoOwn = pRho.patchInternalField()()[faceI]
                          + (deltaOwn & pGradRho.patchInternalField()()[faceI]);
            scalar rhoNei = pRho.patchNeighbourField()()[faceI]
                          + (deltaNei & pGradRho.patchNeighbourField()()[faceI]);

            vector UOwn = pU.patchInternalField()()[faceI]
                        + (deltaOwn & pGradU.patchInternalField()()[faceI]);
            vector UNei = pU.patchNeighbourField()()[faceI]
                        + (deltaNei & pGradU.patchNeighbourField()()[faceI]);

            scalar pOwn = pp.patchInternalField()()[faceI]
                        + (deltaOwn & pGradp.patchInternalField()()[faceI]);
            scalar pNei = pp.patchNeighbourField()()[faceI]
                        + (deltaNei & pGradp.patchNeighbourField()()[faceI]);

            calculateFlux
            (
                pF0[faceI],
                pF123[faceI],
                pF4[faceI],

                rhoOwn,
                UOwn,
                pOwn,

                rhoNei,
                UNei,
                pNei,

                Sf,
                magSf,
                beta,

                pR[faceI],
                pRT[faceI]
            );
        }

    }
    else
    {
        // Actual boundary

        const vectorField pDelta = mesh.boundary()[patchI].delta();

        forAll(mesh.boundary()[patchI], faceI)
        {
            scalar iP = pp.patchInternalField()()[faceI];
            vector delta = pDelta[faceI];

            scalar pP = iP + (delta & pGradp.patchInternalField()()[faceI]);

            pF0[faceI] = 0.0;
            pF123[faceI] = pP*pSf[faceI];
            pF4[faceI] = 0.0;
        }
    }
}
