// Read solver settings
#include "readGravitationalAcceleration.H"

IOdictionary fvSolutionDict
(
    IOobject
    (
        "fvSolution",
        runTime.system(),
        mesh,
        IOobject::MUST_READ,
        IOobject::NO_WRITE
    )
);

dictionary& kelecyPletcherDict = fvSolutionDict.subDict("kelecyPletcher");

const label maxPseudoIters = readLabel(kelecyPletcherDict.lookup("maxPseudoIters"));
const scalar rhoTol = readScalar(kelecyPletcherDict.lookup("rhoTol"));
const scalar rhoUTol = readScalar(kelecyPletcherDict.lookup("rhoUTol"));
const scalar pTol = readScalar(kelecyPletcherDict.lookup("pTol"));
const scalar beta = readScalar(kelecyPletcherDict.lookup("beta"));
const label nRungeKuttaSteps = readLabel(kelecyPletcherDict.lookup("nRungeKuttaSteps"));
const scalar deltaTauCoNum = readScalar(kelecyPletcherDict.lookup("deltaTauCoNum"));
const scalar deltaTCoNum = readScalar(kelecyPletcherDict.lookup("deltaTCoNum"));
const scalar deltaTauFirst = readScalar(kelecyPletcherDict.lookup("deltaTau"));
const scalar deltaTFirst = readScalar(kelecyPletcherDict.lookup("deltaT"));

const bool transient = readBool(kelecyPletcherDict.lookup("transient"));
const bool specialGradp = readBool(kelecyPletcherDict.lookup("specialGradp"));

dimensionedScalar betaDim = dimensionedScalar("betaDim", dimPressure, beta);
dimensionedScalar deltaT = dimensionedScalar("deltaT", dimTime, deltaTFirst);

if(transient == 0)
{
    runTime.setDeltaT(deltaTauFirst);
}
else
{
    runTime.setDeltaT(deltaTFirst);
}

// Create primitive variables
volScalarField rho
(
    IOobject
    (
        "rho",
        runTime.timeName(),
        mesh,
        IOobject::MUST_READ,
        IOobject::AUTO_WRITE
    ),
    mesh
);

volVectorField U
(
    IOobject
    (
        "U",
        runTime.timeName(),
        mesh,
        IOobject::MUST_READ,
        IOobject::AUTO_WRITE
    ),
    mesh
);

volScalarField p
(
    IOobject
    (
        "p",
        runTime.timeName(),
        mesh,
        IOobject::MUST_READ,
        IOobject::AUTO_WRITE
    ),
    mesh
);

// Create gradients of primitive variables
volVectorField gradRho
(
    IOobject
    (
        "gradRho",
        runTime.timeName(),
        mesh,
        IOobject::NO_READ,
        IOobject::AUTO_WRITE
    ),
    fvc::grad(rho)
);

volTensorField gradU
(
    IOobject
    (
        "gradU",
        runTime.timeName(),
        mesh,
        IOobject::NO_READ,
        IOobject::AUTO_WRITE
    ),
    fvc::grad(U)
);

volVectorField gradp
(
    IOobject
    (
        "gradp",
        runTime.timeName(),
        mesh,
        IOobject::NO_READ,
        IOobject::AUTO_WRITE
    ),
    mesh,
    dimensionedVector("tmp", dimPressure/dimLength, vector(0,0,0))
);

// Create conserved variables
volVectorField rhoU
(
    IOobject
    (
        "rhoU",
        runTime.timeName(),
        mesh,
        IOobject::NO_READ,
        IOobject::NO_WRITE
    ),
    rho * U
);

volScalarField P
(
    IOobject
    (
        "P",
        runTime.timeName(),
        mesh,
        IOobject::NO_READ,
        IOobject::NO_WRITE
    ),
    p / betaDim
);

// Create local pseudo time steps
volScalarField localDeltaTau
(
    IOobject
    (
        "localDeltaTau",
        runTime.timeName(),
        mesh,
        IOobject::NO_READ,
        IOobject::NO_WRITE
    ),
    mesh,
    dimensionedScalar("deltaTau", dimTime, deltaTauFirst)
);

// Create flux fields
surfaceScalarField F0
(
    IOobject
    (
        "F0",
        runTime.timeName(),
        mesh,
        IOobject::NO_READ,
        IOobject::NO_WRITE
    ),
    mesh,
    dimensionedScalar("tmp", dimDensity*dimVelocity*dimArea, 0.0)
);

surfaceVectorField F123
(
    IOobject
    (
        "F123",
        runTime.timeName(),
        mesh,
        IOobject::NO_READ,
        IOobject::NO_WRITE
    ),
    mesh,
    dimensionedVector("tmp", dimPressure*dimArea, vector(0,0,0))
);

surfaceScalarField F4
(
    IOobject
    (
        "F4",
        runTime.timeName(),
        mesh,
        IOobject::NO_READ,
        IOobject::NO_WRITE
    ),
    mesh,
    dimensionedScalar("tmp", dimVelocity*dimArea, 0.0)
);

// Initialise last real time
volScalarField rhoN = rho;
volVectorField rhoUN = rhoU;
volScalarField PN = P;

// Initialise last pseudo time
volScalarField rhoM = rho;
volVectorField rhoUM = rhoU;
volScalarField PM = P;

// Create rotation matrices
surfaceTensorField R
(
    IOobject
    (
        "R",
        runTime.timeName(),
        mesh,
        IOobject::NO_READ,
        IOobject::NO_WRITE
    ),
    mesh,
    dimensionedTensor("tmp", dimless, tensor(0,0,0,0,0,0,0,0,0))
);

surfaceTensorField RT
(
    IOobject
    (
        "RT",
        runTime.timeName(),
        mesh,
        IOobject::NO_READ,
        IOobject::NO_WRITE
    ),
    mesh,
    dimensionedTensor("tmp", dimless, tensor(0,0,0,0,0,0,0,0,0))
);

forAll(mesh.owner(), faceI)
{
    createRotationMatrices
    (
        R[faceI],
        RT[faceI],
        mesh.Sf()[faceI],
        mesh.magSf()[faceI]
    );
}

forAll(mesh.boundary(), patchI)
{
    const vectorField& pSf = mesh.Sf().boundaryField()[patchI];
    const scalarField& pMagSf = mesh.magSf().boundaryField()[patchI];

    forAll(pSf, faceI)
    {
        createRotationMatrices
        (
            R.boundaryFieldRef()[patchI][faceI],
            RT.boundaryFieldRef()[patchI][faceI],
            pSf[faceI],
            pMagSf[faceI]
        );
    }
}
