void createRotationMatrices
(
    tensor& R,
    tensor& RT,
    const vector& Sf,
    const scalar& magSf
)
{
    // Unit normal vector
    vector nf = Sf/magSf;

    scalar nx = nf.component(0);
    scalar ny = nf.component(1);
    scalar nz = nf.component(2);

    // Unit vector t1 perpendicular to nf
    scalar t1x = 0;
    scalar t1y = 0;
    scalar t1z = 0;

    if (nx == 0)
    {
        t1x = 1;
    } else if (ny == 0)
    {
        t1y = 1;
    } else
    {
        t1x = ny/Foam::sqrt(nx*nx + ny*ny);
        t1y = -nx/Foam::sqrt(nx*nx + ny*ny);
    }

    // Unit vector t2 orthogonal to nf, t1
    scalar t2x = ny*t1z - nz*t1y;
    scalar t2y = nz*t1x - nx*t1z;
    scalar t2z = nx*t1y - ny*t1x;

    // Rotation matrix from nf to x-axis
    R.component(0) = nx;
    R.component(1) = ny;
    R.component(2) = nz;

    R.component(3) = t1x;
    R.component(4) = t1y;
    R.component(5) = t1z;

    R.component(6) = t2x;
    R.component(7) = t2y;
    R.component(8) = t2z;

    // Rotation matrix from x-axis to nf (transpose)
    RT.component(0) = nx;
    RT.component(3) = ny;
    RT.component(6) = nz;

    RT.component(1) = t1x;
    RT.component(4) = t1y;
    RT.component(7) = t1z;

    RT.component(2) = t2x;
    RT.component(5) = t2y;
    RT.component(8) = t2z;
}
