Info << "Calculating density and velocity gradient" << endl;

gradRho = fvc::grad(rho);
gradU = fvc::grad(U);

gradRho.correctBoundaryConditions();
gradU.correctBoundaryConditions();

Info << "Calculating pressure gradient" << endl;

if(specialGradp == 0)
{

    gradp = fvc::grad(p);

}else{

    volScalarField u = U.component(0);
    volScalarField v = U.component(1);
    volScalarField w = U.component(2);

    volScalarField gradRho_x = gradRho.component(0);
    volScalarField gradRho_y = gradRho.component(1);
    volScalarField gradRho_z = gradRho.component(2);

    volScalarField gradu_x = gradU.component(0);
    volScalarField gradu_y = gradU.component(3);
    volScalarField gradu_z = gradU.component(6);

    volScalarField gradv_x = gradU.component(1);
    volScalarField gradv_y = gradU.component(4);
    volScalarField gradv_z = gradU.component(7);

    volScalarField gradw_x = gradU.component(2);
    volScalarField gradw_y = gradU.component(5);
    volScalarField gradw_z = gradU.component(8);

    volScalarField gradp_x =
            - rhoU_t.component(0)
            - (u*u*gradRho_x + 2*rho*u*gradu_x)
            - (u*v*gradRho_y + rho*u*gradv_y + rho*v*gradu_y)
            - (u*w*gradRho_z + rho*u*gradw_z + rho*w*gradu_z)
            + rhog.component(0);

    volScalarField gradp_y =
            - rhoU_t.component(1)
            - (u*v*gradRho_x + rho*u*gradv_x + rho*v*gradu_x)
            - (v*v*gradRho_y + 2*rho*v*gradv_y)
            - (v*w*gradRho_z + rho*v*gradw_z + rho*w*gradv_z)
            + rhog.component(1);

    volScalarField gradp_z =
            - rhoU_t.component(2)
            - (u*w*gradRho_x + rho*u*gradw_x + rho*w*gradu_x)
            - (v*w*gradRho_y + rho*v*gradw_y + rho*w*gradv_y)
            - (w*w*gradRho_z + 2*rho*w*gradw_z)
            + rhog.component(2);

    forAll(mesh.C(), cellI)
    {
        gradp[cellI].component(0) = gradp_x[cellI];
        gradp[cellI].component(1) = gradp_y[cellI];
        gradp[cellI].component(2) = gradp_z[cellI];
    }

}

gradp.correctBoundaryConditions();
