void roeFlux
(
    scalar& F0,
    vector& F123,
    scalar& F4,
    const scalar& rhoL,
    const vector& UL,
    const scalar& pL,
    const scalar& rhoR,
    const vector& UR,
    const scalar& pR,
    const scalar& beta
)
{
    // Conserved variables
    scalar uL = UL.component(0);
    scalar vL = UL.component(1);
    scalar wL = UL.component(2);

    scalar uR = UR.component(0);
    scalar vR = UR.component(1);
    scalar wR = UR.component(2);

    arma::dvec CL(5,arma::fill::zeros);
    CL[0] = rhoL;
    CL[1] = rhoL*uL;
    CL[2] = rhoL*vL;
    CL[3] = rhoL*wL;
    CL[4] = pL/beta;

    arma::dvec CR(5,arma::fill::zeros);
    CR[0] = rhoR;
    CR[1] = rhoR*uR;
    CR[2] = rhoR*vR;
    CR[3] = rhoR*wR;
    CR[4] = pR/beta;

    // Roe averages
    scalar rho = Foam::sqrt(rhoL*rhoR);
    scalar u = (Foam::sqrt(rhoL)*uL + Foam::sqrt(rhoR)*uR)/
            (Foam::sqrt(rhoL) + Foam::sqrt(rhoR));
    scalar v = (Foam::sqrt(rhoL)*vL + Foam::sqrt(rhoR)*vR)/
            (Foam::sqrt(rhoL) + Foam::sqrt(rhoR));
    scalar w = (Foam::sqrt(rhoL)*wL + Foam::sqrt(rhoR)*wR)/
            (Foam::sqrt(rhoL) + Foam::sqrt(rhoR));

    // Fluxes
    arma::dvec FxL(5,arma::fill::zeros);
    FxL[0] = CL[1];
    FxL[1] = CL[1]*CL[1]/CL[0] + pL;
    FxL[2] = CL[1]*CL[2]/CL[0];
    FxL[3] = CL[1]*CL[3]/CL[0];
    FxL[4] = CL[1]/CL[0];

    arma::dvec FxR(5,arma::fill::zeros);
    FxR[0] = CR[1];
    FxR[1] = CR[1]*CR[1]/CR[0] + pR;
    FxR[2] = CR[1]*CR[2]/CR[0];
    FxR[3] = CR[1]*CR[3]/CR[0];
    FxR[4] = CR[1]/CR[0];

    // Eigenvalues
    scalar cx = Foam::sqrt(u*u + 4*(beta/rho));
    scalar Ex4 = 0.5*(u + cx);
    scalar Ex5 = 0.5*(u - cx);

    arma::dmat Ex(5,5,arma::fill::zeros);

    Ex[0] = fabs(u);
    Ex[6] = fabs(u);
    Ex[12] = fabs(u);
    Ex[18] = fabs(Ex4);
    Ex[24] = fabs(Ex5);

    // Right eigenvectors
    arma::dmat Rx(5,5,arma::fill::zeros);

    Rx[0] = 1.0;
    Rx[1] = u;

    Rx[7] = 1.0;

    Rx[13] = 1.0;

    Rx[15] = Ex4;
    Rx[16] = u*Ex4 + beta/rho;
    Rx[17] = v*Ex4;
    Rx[18] = w*Ex4;
    Rx[19] = -Ex5/rho;

    Rx[20] = Ex5;
    Rx[21] = u*Ex5 + beta/rho;
    Rx[22] = v*Ex5;
    Rx[23] = w*Ex5;
    Rx[24] = -Ex4/rho;

    // Left eigenvectors
    arma::dmat Lx(5,5,arma::fill::zeros);

    Lx[0] = 1.0 + u*u*rho/beta;
    Lx[1] = u*u*v*rho/beta;
    Lx[2] = u*u*w*rho/beta;
    Lx[3] = -u*Ex4*rho/(beta*cx);
    Lx[4] = u*Ex5*rho/(beta*cx);

    Lx[5] = -rho*u/beta;
    Lx[6] = -u*v*rho/beta;
    Lx[7] = -u*w*rho/beta;
    Lx[8] = Ex4*rho/(beta*cx);
    Lx[9] = -Ex5*rho/(beta*cx);

    Lx[11] = 1.0;

    Lx[17] = 1.0;

    Lx[20] = -rho;
    Lx[21] = -rho*v;
    Lx[22] = -rho*w;
    Lx[23] = rho/cx;
    Lx[24] = -rho/cx;

    // Flux calculation
    arma::dvec F(5,arma::fill::zeros);
    F = 0.5*(FxL + FxR - Rx*Ex*Lx*(CR - CL));

    F0 = F[0];
    F123 = vector(F[1], F[2], F[3]);
    F4 = F[4];
}
