volScalarField ux = U.component(0);
volScalarField cx = Foam::sqrt(ux*ux + 4*betaDim/rho);

volScalarField uy = U.component(1);
volScalarField cy = Foam::sqrt(uy*uy + 4*betaDim/rho);

volScalarField uz = U.component(2);
volScalarField cz = Foam::sqrt(uz*uz + 4*betaDim/rho);

scalarField sx = (mag(ux) + cx)*fvc::surfaceSum(mag(mesh.Sf().component(0)))/4;
scalarField sy = (mag(uy) + cy)*fvc::surfaceSum(mag(mesh.Sf().component(1)))/4;
scalarField sz = (mag(uz) + cz)*fvc::surfaceSum(mag(mesh.Sf().component(2)))/4;

scalarField localRatio = mesh.V()/(sx + sy + sz);

forAll(mesh.C(),i)
{
    localDeltaTau[i] = deltaTauCoNum * localRatio[i];
}
