# defining the functions

plot_one <- function(time, folder){
  
  drho_dx_index <- 5
  du_dx_index <- 2
  dv_dx_index <- 3
  dw_dx_index <- 4
  dp_dx_index <- 8
  
  file1 <- "line_p_rho.xy"
  file2 <- "line_U_gradRho_gradp.xy"
  file3 <- "line_gradU.xy"
  
  filename1 <- sprintf("%s/%s/%s", folder, time, file1)
  df1 <- read.table(filename1)
  
  filename2 <-sprintf("%s/%s/%s", folder, time, file2)
  df2 <- read.table(filename2)
  
  filename3 <-sprintf("%s/%s/%s", folder, time, file3)
  df3 <- read.table(filename3)
  
  #par(mfrow = c(1,1))
  par(mfrow = c(5,1))
  par(mar = c(2,4,1,1))
  
  # rho
  plot(df1[,1], df1[,3], xlab = NA, ylab = "rho", type = "l", ylim = c(0,1010))

  # u
  plot(df1[,1], df2[,2], xlab = NA, ylab = "u", type = "l", ylim = c(-0.1,0.1))

  # v
  plot(df1[,1], df2[,3], xlab = NA, ylab = "v", type = "l", ylim = c(-0.1,0.1))
  
  # w
  plot(df1[,1], df2[,4], xlab = NA, ylab = "w", type = "l", ylim = c(-0.1,0.1))
  
  # p
  plot(df1[,1], df1[,2], xlab = NA, ylab = "p", type = "l", ylim = c(-2000,16000))
  
}

plot_all <- function(times, folder){
  lapply(times, plot_one, folder = folder)
}

plot_last <- function(times, folder){
  plot_one(times[length(times)], folder)
}

# using the functions

setwd(dirname(parent.frame(2)$ofile))

folder <- "postProcessing/singleGraph"
times <- list.dirs(folder, full.names = F, recursive = F)
times <- times[2:length(times)]
times_subset <- times[seq(1, length(times), 20)]

plot_last(times, folder)

library(gifski)
gif_filepath <- "slice.gif"
delay <- (max(as.numeric(times))-min(as.numeric(times)))/length(times)
save_gif(plot_all(times_subset,folder), gif_filepath, delay = delay, width = 500, height = 500)
