{
    Info << nl << "Solving air scalars" << endl;

    tmp<fv::convectionScheme<scalar> > yConvection
    (
        fv::convectionScheme<scalar>::New
        (
            airMesh,
            airYs,
            phiAir,
            airMesh.divScheme("div(phi,y)")
        )
    );
    volScalarField eAir = matAir.epsilon0()*(1.0 - sAir);
    surfaceScalarField eAirf = fvc::interpolate(eAir);

    label inertIndex = -1;
    volScalarField Yt("Yt", 0.0*Yair[0]);

    for (label i = 0; i < Yair.size(); i++)
    {
        Info << " Yair[i].name() = " << Yair[i].name() << nl;

        if (matAir.species()[i].name() != matAir.inertSpecie())
        {
            volScalarField& Yi = Yair[i];
            volScalarField& diffAirS = matAir.diffusivity()[i];

            fvScalarMatrix YiEqn
            (
                fvm::ddt(eAir*matAir.rho(), Yi)
              + yConvection->fvmDiv(eAirf*phiAir, Yi)
              - fvm::laplacian(eAir*matAir.rho()*diffAirS, Yi, "laplacian(diff,y)")
            );

	    if(i == matAir.waterIndex()) // vapour to liquid
	    {
		YiEqn -= phaseChangeAir.Svl();
	    }
            YiEqn.relax();
            YiEqn.solve(airMesh.solverDict("Yi"));

            //Yi.max(0.0);
            Yi.max(Foam::doubleScalarSMALL);
            Yt += Yi;
        }
        else
        {
            inertIndex = i;
        }
    }

    Info<< "inertIndex = " << inertIndex << nl;
    Yair[inertIndex] = scalar(1) - Yt;
    Yair[inertIndex].correctBoundaryConditions();
    Yair[inertIndex].max(Foam::doubleScalarSMALL);


    forAll(Yair, i)
    {
	//lim.limit(Yair[i], 0, 1, true); // limit to values between 0 and 1
	lim.check(Yair[i], 0, 1);
    }
    matAir.updateMoleFractions();
}
