    Info<< "Reading cell properties\n" << endl;

    IOdictionary cellProperties
    (
        IOobject
        (
            "cellProperties",
            runTime.constant(),
            mesh,
            IOobject::MUST_READ,
            IOobject::NO_WRITE
        )
    );

    dimensionedScalar Tref("Tref", dimTemperature, cellProperties);
    dimensionedScalar Tlim("Tlim", dimTemperature, -1.0, cellProperties);

    Info<< "    Tref = " << Tref << nl;
    Info<< endl;

    word interconnectName(cellProperties.lookupOrDefault<word>("interconnectName", "interconnect"));
    word airName(cellProperties.lookupOrDefault<word>("cathodeName", "air"));
    word fuelName(cellProperties.lookupOrDefault<word>("anodeName", "fuel"));
    word electrolyteName(cellProperties.lookupOrDefault<word>("electrolyteName", "electrolyte"));
