// update material database
{
    matAir.updateMaterialProperties();
    matFuel.updateMaterialProperties();
    nuAir = matAir.nu(); // needed for some boundary condition
    nuFuel = matFuel.nu();

    // check if density changes much compared to the value in phaseProperties
    scalar deltaRhoAir = mag(rhoA.value() - gAverage(matAir.rho()));
    scalar deltaRhoFuel = mag(rhoF.value() - gAverage(matFuel.rho()));
    if(deltaRhoAir > 0.05)
    {
        Info<< "Warning: rhoAir is 5% different from initial rho in phaseProperties!" << endl;
    }
    if(deltaRhoFuel > 0.05)
    {
        Info<< "Warning: rhoFuel is 5% different from initial rho in phaseProperties!" << endl;
    }
}
