/*---------------------------------------------------------------------------*\
  =========                 |
  \\      /  F ield         | OpenFOAM: The Open Source CFD Toolbox
   \\    /   O peration     |
    \\  /    A nd           | Copyright held by original author
     \\/     M anipulation  |
-------------------------------------------------------------------------------
License
    This file is part of OpenFOAM.

    OpenFOAM is free software; you can redistribute it and/or modify it
    under the terms of the GNU General Public License as published by the
    Free Software Foundation; either version 2 of the License, or (at your
    option) any later version.

    OpenFOAM is distributed in the hope that it will be useful, but WITHOUT
    ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
    FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
    for more details.

    You should have received a copy of the GNU General Public License
    along with OpenFOAM; if not, write to the Free Software Foundation,
    Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA

Class
    Foam::noActivation

Description
    No activation overpotential.

\*---------------------------------------------------------------------------*/

#ifndef noActivation_H
#define noActivation_H

#include "activationOverpotentialModel.H"
#include "dimensionedScalar.H"
#include "primitiveFieldsFwd.H"
#include "labelList.H"
#include "volFieldsFwd.H"
#include "fvMesh.H"

// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

namespace Foam
{

/*---------------------------------------------------------------------------*\
                           Class noActivation Declaration
\*---------------------------------------------------------------------------*/

class noActivation
:
    public activationOverpotentialModel
{
    // Private member functions

        //- Disallow copy construct
        noActivation(const noActivation&) = delete;

        //- Disallow default bitwise assignment
        void operator=(const noActivation&) = delete;


public:

    //- Runtime type information
    TypeName("noActivation");


    // Constructors

        noActivation
        (
            const speciesTable& speciesNames,
            const dictionary& dict
        );


    // Destructor

        ~noActivation()
        {}


    // Member functions

	//- Returns the exchange current density
        virtual const tmp<scalarField> exchangeCurrentDensity
        (
            const scalarField& electrodeT,
            const scalarField& pPatch,
            const PtrList<scalarField> molFraction
        ) const;

	//- Returns the current density as a function of overpotential
        virtual tmp<scalarField> currentDensity
        (
            const scalarField& electrodeT,
            const scalarField& pPatch,
            const PtrList<scalarField> molFraction,
            const scalarField& overPotential
        ) const;

	//- Returns the overpotential as a function of current density
        virtual tmp<scalarField> overPotential
        (
            const scalarField& electrodeT,
            const scalarField& pPatch,
            const PtrList<scalarField> molFraction,
            const scalarField& waterBlockage,
            const scalarField& currentDensity
        ) const;
};


// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

} // End namespace Foam

// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

#endif

// ************************************************************************* //
