/*---------------------------------------------------------------------------*\
  =========                 |
  \\      /  F ield         | OpenFOAM: The Open Source CFD Toolbox
   \\    /   O peration     |
    \\  /    A nd           | Copyright held by original author
     \\/     M anipulation  |
-------------------------------------------------------------------------------
License
    This file is part of OpenFOAM.

    OpenFOAM is free software; you can redistribute it and/or modify it
    under the terms of the GNU General Public License as published by the
    Free Software Foundation; either version 2 of the License, or (at your
    option) any later version.

    OpenFOAM is distributed in the hope that it will be useful, but WITHOUT
    ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
    FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
    for more details.

    You should have received a copy of the GNU General Public License
    along with OpenFOAM; if not, write to the Free Software Foundation,
    Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA

Class
    Foam::materialDatabase

Description
    Provides material properties of a gas.

\*---------------------------------------------------------------------------*/

{
    // species names
    speciesTable speciesNames_(speciesDict_.lookup("species"));

    // species data
    forAll(speciesNames_, i)
    {
        fuelCellSpecies tmp(speciesDict_.lookup(speciesNames_[i]));
        species_.set
        (
            i,
            new fuelCellSpecies(tmp)
        );
    }

    // background specie for mass fraction calculations
    // -----------------
    // labelled inertSpecie but NOT necessarily chemically inert)
    Info<< "    " << zName_ << "InertSpecie = " << inertSpecie_ << nl << endl;

    if (!speciesNames_.found(inertSpecie_))
    {
        FatalErrorIn("material properties")
            << "Specified inert specie '" << inertSpecie_ << "' not found in "
            << "species list. Available species:" << speciesNames_
            << exit(FatalError);
    }

    // mole fraction fields and files
    forAll(species_, i)
    {
        X_.set
        (
            i,
            new volScalarField
            (
                IOobject
                (
                    "X" + species_[i].name(),
                    mesh_.time().timeName(),
                    mesh_,
                    IOobject::READ_IF_PRESENT,
                    IOobject::AUTO_WRITE
                ),
                mesh_,
                dimensionedScalar("x", dimensionSet(0,0,0,0,0,0,0), 1),
                zeroGradientFvPatchScalarField::typeName
            )
        );
    }
    updateMoleFractions();

    forAll(speciesNames_, i)
    {
        if(speciesNames_[i] == "H2O")
        {
            H2O_=i;
        }
    }
}

// ************************************************************************* //
