clear all, clc, clf, close all
% -------------- Plot constants --------------- %
ln = 1.5;
lnn = 1.5; fsS = 16; fsL = 24;

ts = 500;
dt = 0.0001;
tmFunc = 0:dt:30;

% -------------- kValve function --------------- %
bc = [-2.146874751799431  12.162394718516090];
kFuncExport =@(opening) exp(bc(1)*log(opening)+bc(2));

% ------------ Valve closing time -------------- %
y1 =@(x) (2-250)/5*x+250;

SF=10; % Scale Factor (for smoothing)
t1 = [-0.1 -0.05 -0.03 0.01 0.1]*SF;
t1 = t1 + 5;
OValve1 = [y1(t1(1)) y1(t1(2)) y1(t1(3)) 2 2];
tmF1 = linspace(t1(1),t1(end),2000);
OvectSmooth1 = pchip(t1,OValve1,tmF1);
tmF1 = tmF1 + 5;

% ------------ Valve opening time -------------- %
y2 =@(x) (250-2)/5*x+2;
t2 = [-0.1 -0.01 0.03 0.05 0.1]*SF;
OValve2 = [2 2 y2(t2(end-2)) y2(t2(end-1)) y2(t2(end))];
tmF2 = linspace(t2(1),t2(end),2000);
OvectSmooth2 = pchip(t2,OValve2,tmF2);
tmF2 = tmF2 + 18;

% ---------- Assemble transient time ------------ %
Texp1 = linspace(5,tmF1(1),ts);
Oexpt1 = linspace(250,OvectSmooth1(2),ts);
Texp2 = linspace(tmF2(end),23,ts);
Oexpt2 = linspace(OvectSmooth2(end),250,ts);

Tvect = [0 Texp1 tmF1(2:end) tmF2(1:end-1) Texp2  31];
Ovect = [250 Oexpt1 OvectSmooth1(2:end) OvectSmooth2(1:end-1) Oexpt2 250];

% ---------- Create kValve(opening) ------------- %
kValve = kFuncExport(Ovect) - kFuncExport(Ovect(1));

% ---------- Export time and kValve ------------- %
[Tvect' kValve'];
fidkValve = fopen (['kValve'], "w");
	fprintf (fidkValve, "(\n");
	for i=1:length(kValve)
		fprintf (fidkValve, ['    (' num2str(Tvect(i)) ' ' num2str(kValve(i)) ')\n']);
	end
	fprintf (fidkValve, ');');
fclose (fidkValve);


% ------ Plot valve opening and kValve --------- %
subYlim = [1.99 2.01];
subdT = 0.02;
close all
figure(4) 
set(gcf,'Position',[150 500 2000 600])
	subplot(1,8,1:5)
		yyaxis right	
			p2 = plot(Tvect,kValve, '--b','linewidth',ln); hold on
			ylabel('$k_\mathrm{valve}$','fontsize', fsL,'Interpreter','latex')
			set(gca, 'YScale', 'log');
			ylim([1e-2 1e6]) 
		yyaxis left	
			p1 = plot(Tvect,Ovect,'k','linewidth',ln); hold on
			xlim([0 30])
			ylim([0 300]) 
			grid on
			set(gca, "linewidth", 1, "fontsize", fsS)
			xlabel('Time (s)','fontsize', fsL,'Interpreter','latex')
			ylabel('$v$ (mm)','fontsize', fsL,'Interpreter','latex')
		ax = gca;
		ax.YAxis(1).Color = 'k';
		ax.YAxis(2).Color = 'k';
		set(ax,'ticklabelinterpreter','latex') ;
	subplot(2,8,7:8)
		yyaxis right	
			p2 = plot(Tvect,kValve, '--b','linewidth',ln); hold on
			ylabel('$k_\mathrm{valve}$','fontsize', fsL,'Interpreter','latex')
			set(gca, 'YScale', 'log');
			ylim([2e3 1e5]) 
		yyaxis left	
			p1 = plot(Tvect,Ovect,'k','linewidth',ln); hold on
			subXlim = [-subdT subdT]+10.1;
			xlim([9.8 10.2])
			ylim([1 10]) 
			grid on
			set(gca, "linewidth", 1, "fontsize", fsS)
			xlabel('Time (s)','fontsize', fsL,'Interpreter','latex')
			ylabel('$v$ (mm)','fontsize', fsL,'Interpreter','latex')
		ax = gca;
		ax.YAxis(1).Color = 'k';
		ax.YAxis(2).Color = 'k';
		set(ax,'ticklabelinterpreter','latex') ; %or 'tex' but not 'latex'  

	subplot(2,8,15:16)
		yyaxis right	
			p2 = plot(Tvect,kValve, '--b','linewidth',ln); hold on
			ylabel('$k_\mathrm{valve}$','fontsize', fsL,'Interpreter','latex')
			set(gca, 'YScale', 'log');
			ylim([2e3 1e5]) 
		yyaxis left	
			p1 = plot(Tvect,Ovect,'k','linewidth',ln); hold on
			subXlim = [-subdT subdT]+17.9;
			xlim([17.8 18.2])
			ylim([1 10]) 
			grid on
			set(gca, "linewidth", 1, "fontsize", fsS)
			xlabel('Time (s)','fontsize', fsL,'Interpreter','latex')
			ylabel('$v$ (mm)','fontsize', fsL,'Interpreter','latex')
		ax = gca;
		ax.YAxis(1).Color = 'k';
		ax.YAxis(2).Color = 'k';
		set(ax,'ticklabelinterpreter','latex') ; %or 'tex' but not 'latex'
	hL=legend([p1 p2], '$v$ \quad', '$k_\mathrm{valve}$');
	newPosition = [0.275 0.88 0.2 0.2];
	newUnits = 'normalized';
	set(hL,'Position', newPosition,'Units', newUnits,"fontsize", fsL,'Interpreter','latex','orientation','horizontal');
	legend boxoff
if ~exist('Figures', 'dir')
   mkdir('Figures')
end
saveas(4, ['Figures/Opening_kValve_vs_t_SF' num2str(SF) '_subPlots.eps'],'epsc')

	
