# cfd.xyz - An open-source web app for generating and visualizing parametric CFD results

[![Website shields.io](https://img.shields.io/website-up-down-green-red/http/shields.io.svg)](http://cfd.xyz)
[![Docker](https://badgen.net/badge/icon/docker?icon=docker&label)](https://github.com/orgs/simzero-oss/packages/container/package/cfd-xyz)
[![stability-beta](https://img.shields.io/badge/stability-beta-33bbff.svg)](https://github.com/simzero-oss/cfd-xyz/releases)
[![Join Slack](https://img.shields.io/badge/Join%20us%20on-Slack-e01563.svg)](https://join.slack.com/t/cfd-xyz/shared_invite/zt-15qjacmzo-1woWqeklQ0IeXZb_F6ueaQ)
[![License: MIT](https://img.shields.io/badge/License-MIT-yellow.svg)](https://github.com/simzero-oss/cfd-xyz/blob/main/LICENSE)
[![License: CC BY 4.0](https://img.shields.io/badge/License-CC%20BY%204.0-lightgrey.svg)](https://creativecommons.org/licenses/by/4.0/)

[cfd.xyz](http://cfd.xyz) is an open-source web app to efficiently and easily explore fluid dynamics problems for a wide range of parameters. The framework provides a proof of technology for OpenFOAM tutorials, showing the whole process from the generation of the surrogate models to the web browser. It also includes a standalone web tool for visualizing users' models by directly dragging and dropping the output folder of the ROM offline stage. Beyond the current proof of technology, this enables a collaborative effort for the implementation of OpenFOAM-based surrogate models in applications demanding real-time solutions such as digital twins and other digital transformation technologies.

We aim with the developments presented in this work to create a common place where canonical and industrial CFD problems can be visualized and analyzed without carrying out a simulation, or as a preliminary step for optimizing parameters of new simulations. Having an open-source centralized service has several advantages from educational, optimization and reproducibility point of views. But also from a CO2 footprint perspective.

The web app relies on the [rom.js](https://github.com/simzero-oss/rom-js) module, a JavaScript port of a set of open-source packages (Eigen, Splinter and VTK/C++, ITHACA-FV) to solve the online stage of reduced-order models (ROM) generated by the ITHACA-FV tool. It can also be executed outside a web browser within a backend JavaScript runtime environment, or in a given web solution.


This is a beta version, please handle it with care. Further features, optimizations and fixes are expected. We are also working on including machine learning data-driven methods. Contact us or join the [Slack channel](https://join.slack.com/t/cfd-xyz/shared_invite/zt-12uquswo6-FFVy95vRjfMF~~t8j~UBHA) if you want to collaborate.

### Requirements

* [Docker](https://www.docker.com/get-started) 20.10.12
* npm 6.14.11 (optional)

## Installation

You can install and serve `cfd-xyz` in your computer with `npm`:

```
VERSION=v1.0.0-rc.8 make all
```

And use the web by entering `http://localhost:3000` in your browser.

Alternatively, you can use the [Docker image](https://github.com/orgs/simzero-oss/packages/container/package/cfd-xyz) for building and serving the web:

```
VERSION=v1.0.0-rc.8 make all-docker
```

The web will be accessible at `http://localhost:5000`.

## Development

The web app reads data from the `public/surrogates` folder for the interactive visualization. The instructions above install the data automatically but you can copy and paste the `surrogates` folder generated by [rom.js](https://github.com/simzero-oss/rom-js).

## Contributing

Everyone is welcome to contribute to this project. See [CONTRIBUTING.md](https://github.com/simzero-oss/cfd-xyz/blob/main/CONTRIBUTING.md) for further details.

cfd.xyz is a self-funded initiative, free of charge, with no adds, no popups, no registration and no data collection.

Your donations encourage future developments and help with server costs for providing a better service. If you like the tool you can [:heart: donate](https://www.paypal.com/donate/?hosted_button_id=KKB4LH96E59A4).

## Citation

A technical note related to this work was submitted to the OpenFOAM Journal and it is currently being reviewed. In the meanwhile please use the following bibtex to cite this repository:

- Technical note submitted to the OpenFOAM Journal and under review. Preprint available at arXiv:

```
@misc{cfd_xyz_note_2022,
  doi = {10.48550/ARXIV.2205.08387},
  url = {https://arxiv.org/abs/2205.08387},
  author = {Peña-Monferrer, Carlos and Díaz-Marín, Carmen},
  keywords = {Fluid Dynamics (physics.flu-dyn), Numerical Analysis (math.NA), FOS: Physical sciences, FOS: Physical sciences, FOS: Mathematics, FOS: Mathematics},
  title = {cfd.xyz/rom.js: An open-source framework for generating and visualizing parametric CFD results on the web},
  publisher = {arXiv},
  year = {2022},
  copyright = {Creative Commons Attribution Share Alike 4.0 International}
}
```

- Web:
```
@online{cfd_xyz_web_2022,
  author = {{SIMZERO}},
  title = {{cfd.xyz}},
  howpublished = {\url{https://cfd-xyz}},
  addendum = "(accessed: 28.04.2022)",
}
```

- Repository:
```
@online{cfd_xyz_repo_2022,
  author       = {{SIMZERO}},
  title = {{cfd.xyz}},
  howpublished = {\url{https://github.com/simzero-oss/cfd-xyz}},
  addendum = "(accessed: 28.04.2022)",
}
```

- Specific version with DOI. Example for v1.0.0-rc.8:
```
@software{cfd_xyz_v1.0.0-rc.8,
  author       = {Carlos Peña-Monferrer and
                  Carmen Díaz-Marín},
  title        = {simzero-oss/cfd-xyz},
  month        = mar,
  year         = 2022,
  publisher    = {Zenodo},
  version      = {v1.0.0-rc.8},
  doi          = {10.5281/zenodo.6365615},
  url          = {https://doi.org/10.5281/zenodo.6365615}
}
```

## License

Code on this repository is covered by the MIT license. All the media/images in the `public` directory are CC BY 4.0 except the `public/constructionSolver.png` image that is covered by CC0, and the cfd.xyz logos (`src/components/Main/logo*.svg`) with CC BY-ND 4.0 license so you may not alter, remix or transform these images. The cfd.xyz logo, SIMZERO and OpenFOAM are trademarks. A full description of the licenses can be found below:

* Code: [MIT](https://github.com/simzero-oss/cfd-xyz/blob/main/LICENSE)
* Media `public/constructionSolver.png`: [CC0](https://github.com/simzero-oss/cfd-xyz/blob/main/LICENSE-CC-0)
* Media `src/components/Main/logoLight.svg` and `src/components/Main/logoDark.svg`: [CC BY-ND 4.0](https://github.com/simzero-oss/cfd-xyz/blob/main/LICENSE-CC-BY-ND) 
* Other media: [CC BY 4.0](https://github.com/simzero-oss/cfd-xyz/blob/main/LICENSE-CC-BY)

* Trademarks:
  - OPENFOAM® is a registered trade mark of OpenCFD Limited, producer and distributor of the OpenFOAM software via [www.openfoam.com](www.openfoam.com).
  - cfd.xyz logo and SIMZERO are exclusive trademarks. Their use is only allowed in the context of this web app and in compliance with trademark law. Adaptations or modifications of the cfd.xyz logo are not permitted.
