#!/bin/bash

PROC=6
BUILD_ROOT=.

echo "#############################"
echo  INITIALIZING THIRD PARTY CODE
echo "#############################"

git submodule update --init --recursive

echo "#############################"
echo  BUILDING OpenFOAM
echo "#############################"

OPENFOAM_ROOT=$BUILD_ROOT/openfoam

source $OPENFOAM_ROOT/etc/bashrc

(cd $OPENFOAM_ROOT && ./Allwmake -j${PROC})

echo "#############################"
echo  BUILDING ITHACA-FV
echo "#############################"

ITHACAFV_ROOT=$BUILD_ROOT/ithaca-fv
APPLICATIONS=../applications

source $ITHACAFV_ROOT/etc/bashrc

(cd $ITHACAFV_ROOT && ./Allwmake -j${PROC})
(cd ${APPLICATIONS}/steady/offline && wmake)
