# Ika-Flow #

**Ika** is a Māori word meaning any creature that swims in fresh or salt water including marine mammals such as whales.

## What is this repository for? ##
This is a repository for code to estimate power and thrust of an undulating fish and related simulations.

This solver can only be run on the openFOAM.com edition of openFOAM due to overset solver support.

To run the code, the dynamicMesh file in src must be compiled using wmake.  This will compile the solver into the FOAM_USER_LIBBIN. An **Allmake** script is further provided that will perform this action.

## Description ##

The case can then be run using the scripts, but the general process is:

- construct the overset mesh from Ansys fluent mesh files in the mesh folder.
- copy the mesh folder into the running folder
- run the case

The **mesh** folder gives the base mesh and a run mesh script is provided. Run this once to generate the base mesh. All cases will use this mesh with the exception of the grid_independence_study cases which have their own mesh.

Each individual case has a **run_all**, **run_mesh**, and **run_solver** script to run the case.

An **Allrun** script is provided that will build the mesh and run the no_movements case. This case is to get a baseline of the force and drag for a non-moving airfoil and will be used in the calculation of the other force and drag coefficients. From here, you can run the cases of interest.

## Case Description ##
After decompressing the **case_files** archive, a description of the cases is as follows:

**anguilliform** has the cases for Anguilliform motion at different Reynolds numbers. The naming scheme gives the Reynolds number and then the Strouhal number for that simulation.

**carangiform** has the cases for Carangiform motion at different Reynolds numbers.  The naming scheme gives the Reynolds number and then the Strouhal number for that simulation.

**data_set** holds all the data for the cases so that the plots can be reploted. Please note that this is provided as a different file and needs to be uncompressed into this folder.

**delay_test** has the cases where the movement of the fish is delayed by 5 and 15 seconds.

**force_Cp_graphs** contain runs for all 4 locomotion modes, animations from the last 2 cycles of a run, force data, force bin data, pressure coefficient data, and a post-processing script for paraview for generating the pressure coefficient data.

**grid_independence_study** contains the cases for performing a grid independence study. The grids are sequentially more refined with 'grid1' being the coarsest grid and 'grid3' being the finest grid. Each case contains it's own 'airfoil' and 'background' folder with the meshes stored in the 'airfoil' folder.

**mesh** contains the base mesh.

**model_comparison** has the cases where different turbulence models are used. The naming scheme is the turbulence model followed by 'low' or 'mid' which corresponds to either a 'low' Reynolds number or 'mid' Reynolds number.

**no_movements** contains cases at different Reynolds numbers where there is just a static airfoil. These are used to get a baseline idea of the lift and drag on a static airfoil.

**ostraciiform** has the cases for Ostraciiform motion at different Reynolds numbers.  The naming scheme gives the Reynolds number and then the Strouhal number for that simulation.

**pimple_iteration_sensitivity** contains the cases where the movement and Reynolds number is kept constant but the number of PIMPLE iterations is changed.

**reduced_case** is a case that is meant to run faster on slower hardware.

**thunniform** has the cases for Thunniform motion at different Reynolds numbers.  The naming scheme gives the Reynolds number and then the Strouhal number for that simulation.

**time_sensitivity_study** contains cases in which the movement and Reynolds number is kept the same but the maxCo is varied. The naming scheme gives which maxCo was used with the 'maxCo2_0_50iters' being the cases in which 50 PIMPLE iterations were used with a maxCo of 2.0.

### **----------------------------Python Scripts--------------------------------** ###

Please note that the **data_set** archive needs to be uncompressed into the **case_files** folder for the above to be correct. Scripts can be run in their own folder when the **data_set** file is uncompressed.

The **forceClass.py** and **forceBinsClass.py** are used in the post processing of OpenFOAM Force data. This is done in the **process_force_data.ipynb** or **process_force_data.py** scripts. The **forces2csv.ipynb** converts the force data to .csv.

The **comparison_cases_plots.ipynb** script gives plots for all the comparison cases.

The **grid_comparison_plots** gives the comparison of all the different grids as well as the validation with Dong and Lu, and Yu et al.

The **plot_Cp_plots.ipynb** gives the plots of the pressure coefficient over the airfoil for different time steps.

The **plot_force_lift_cases** gives plots of lift and drag over the airfoil for different time steps.

### **--------------------------Animations-------------------------------------** ###

The **Animations** archive contains animations for all four modes are provided as an .mp4 file with the locomotion mode as the name of the animation.

## Who do I talk to? ##
This repo is owned by Michael Coe and can be contacted at michael.coe@canterbury.ac.nz or messaged on GitHub.

### License ###
This work is licensed under CC BY 4.0. To view a copy of this license, visit http://creativecommons.org/licenses/by/4.0/